/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tests;

import com.sun.electric.tool.user.tests.AbstractTest;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class TimingAnalysisTest
extends AbstractTest {
    private String name;
    private String functionName;
    private String dspfFile;
    private String cmdFile;
    private String gcfFile;
    private String sdcFile;
    private String oysterNodesFile;
    private String oysterReportFile;
    private List<String> libFiles;
    private List<String> vlFiles;
    private Boolean splitNodes;
    private static boolean oysterTestChecked = false;
    private static Class<?> oysterTestClass = null;
    private static Method oysterTestInputMethod;

    public TimingAnalysisTest(String name) {
        super(name);
        this.functionName = name;
    }

    public TimingAnalysisTest(String name, String functionName, String vlFiles, String libFiles, String dspfFile, String cmdFile, String gcfFile, String sdcFile, String oysterOriginal, String reportFile, Boolean split) {
        super(name);
        StringTokenizer parse;
        this.name = name;
        this.functionName = functionName;
        this.vlFiles = new ArrayList<String>();
        this.libFiles = new ArrayList<String>();
        this.dspfFile = dspfFile;
        this.cmdFile = cmdFile;
        this.gcfFile = gcfFile;
        this.sdcFile = sdcFile;
        this.oysterNodesFile = oysterOriginal;
        this.oysterReportFile = reportFile;
        this.splitNodes = split;
        if (vlFiles != null) {
            parse = new StringTokenizer(vlFiles, "{, }", false);
            while (parse.hasMoreTokens()) {
                this.vlFiles.add(parse.nextToken());
            }
        }
        if (libFiles != null) {
            parse = new StringTokenizer(libFiles, "{, }", false);
            while (parse.hasMoreTokens()) {
                this.libFiles.add(parse.nextToken());
            }
        }
    }

    public static List<AbstractTest> getTests() {
        ArrayList<AbstractTest> list = new ArrayList<AbstractTest>();
        list.add(new TimingAnalysisTest("controlblock with no split", "controlblock", "rk_cb_dsu_cms.vL", "data/u1.lib, data/u1fib.lib", "data/rk_cb_dsu_cms.dspf", "rk_cb_dsu_cms.cmd", null, "rk_cb_dsu_cms.sdc", "report.graph", "nodereport", false));
        list.add(new TimingAnalysisTest("controlblock with split", "controlblock", "rk_cb_dsu_cms.vL", "data/u1.lib, data/u1fib.lib", "data/rk_cb_dsu_cms.dspf", "rk_cb_dsu_cms.cmd", null, "rk_cb_dsu_cms.sdc", "report.graph", "nodereport", true));
        list.add(new TimingAnalysisTest("rk_m_stadd64 with no split", "rk_m_stadd64", "rk_m_stadd64.vL", "data/u1.lib, ", "rk_m_stadd64.dspf", "rk_m_stadd64.cmd", null, "rk_m_stadd64.sdc", "report.graph", "nodereport", false));
        list.add(new TimingAnalysisTest("rk_m_stadd64 with split", "rk_m_stadd64", "rk_m_stadd64.vL", "data/u1.lib, ", "rk_m_stadd64.dspf", "rk_m_stadd64.cmd", null, "rk_m_stadd64.sdc", "report.graph", "nodereport", true));
        list.add(new TimingAnalysisTest("fastProx with no split", "fastProx", "input/testFlops.v", "input/flops.MAX.lib,input/sclibTSMC90.MAX.lib", "input/testFlops.dspf", "fastProx.cmd", null, "fastProx.sdc", "oysterData/report.graph", "oysterData/node-report", false));
        list.add(new TimingAnalysisTest("fastProx with split", "fastProx", "input/testFlops.v", "input/flops.MAX.lib,input/sclibTSMC90.MAX.lib", "input/testFlops.dspf", "fastProx.cmd", null, "fastProx.sdc", "oysterData/report.graph", "oysterData/node-report", true));
        list.add(new TimingAnalysisTest("main_t1 with no split", "main_t1", "{input/main.v}", "input/sc.lib", "input/main.dspf", "main_t1.cmd", null, "main_t1.sdc", "oysterData/report.graph", "oysterData/node-report", false));
        list.add(new TimingAnalysisTest("main_t1 with split", "main_t1", "{input/main.v}", "input/sc.lib", "input/main.dspf", "main_t1.cmd", null, "main_t1.sdc", "oysterData/report.graph", "oysterData/node-report", true));
        list.add(new TimingAnalysisTest("multithread_example with no split", "multithread_example", "input/multithread_example.vL", "input/multithread_example_lib.SynT", "input/multithread_example.dspf", "simple.cmd", null, "simple.sdc", "oysterData/report.graph", "oysterData/node-report", false));
        list.add(new TimingAnalysisTest("multithread_example with split", "multithread_example", "input/multithread_example.vL", "input/multithread_example_lib.SynT", "input/multithread_example.dspf", "simple.cmd", null, "simple.sdc", "oysterData/report.graph", "oysterData/node-report", true));
        return list;
    }

    public static String getOutputDirectory() {
        return null;
    }

    public Boolean controlblock() {
        return this.doIt();
    }

    public Boolean fastProx() {
        return this.doIt();
    }

    public Boolean main_t1() {
        return this.doIt();
    }

    public Boolean multithread_example() {
        return this.doIt();
    }

    public Boolean noise_ch_cq_ctl() {
        return this.doIt();
    }

    public Boolean rk_m_stadd64() {
        return this.doIt();
    }

    public Boolean timingmodel_case1() {
        return this.doIt();
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    public Boolean doIt() {
        if (!TimingAnalysisTest.hasOyster()) {
            return false;
        }
        String testParameter = this.createMessageOutput();
        String path = TimingAnalysisTest.workingDir(this.getRegressionPath(), testParameter) + this.getFunctionName();
        ArrayList<CallSite> fileNamesVerilog = new ArrayList<CallSite>(this.vlFiles.size());
        for (String string : this.vlFiles) {
            fileNamesVerilog.add((CallSite)((Object)(path + "/" + string)));
        }
        ArrayList<CallSite> fileNameLibs = new ArrayList<CallSite>(this.libFiles.size());
        for (String n : this.libFiles) {
            fileNameLibs.add((CallSite)((Object)(path + "/" + n)));
        }
        String string = this.dspfFile != null ? path + "/" + this.dspfFile : null;
        String fileCmd = this.cmdFile != null ? path + "/" + this.cmdFile : null;
        String fileGcf = this.gcfFile != null ? path + "/" + this.gcfFile : null;
        String fileSdc = this.sdcFile != null ? path + "/" + this.sdcFile : null;
        String fileOysterGraph = this.oysterNodesFile != null ? path + "/" + this.oysterNodesFile : null;
        String fileOysterReport = this.oysterReportFile != null ? path + "/" + this.oysterReportFile : null;
        Boolean good = false;
        try {
            Object obj = oysterTestInputMethod.invoke(oysterTestClass, fileNameLibs, fileNamesVerilog, string, fileCmd, fileGcf, fileSdc, fileOysterGraph, fileOysterReport, this.name, this.splitNodes);
            if (obj instanceof Boolean) {
                good = (Boolean)obj;
            }
        }
        catch (Exception e) {
            System.out.println("Unable to run the Oyster test module (" + this.name + ")");
            e.printStackTrace(System.out);
            good = false;
        }
        return good;
    }

    public static boolean hasOyster() {
        if (!oysterTestChecked) {
            oysterTestChecked = true;
            try {
                oysterTestClass = Class.forName("com.sun.electric.plugins.oyster.OysterMain");
            }
            catch (ClassNotFoundException e) {
                oysterTestClass = null;
                return false;
            }
            try {
                oysterTestInputMethod = oysterTestClass.getMethod("oyster_regression", List.class, List.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Boolean.class);
            }
            catch (NoSuchMethodException e) {
                oysterTestClass = null;
                e.printStackTrace();
                return false;
            }
        }
        return oysterTestClass != null;
    }
}

